/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/

/* ---------------------------------------------------------------
 * File: xci.h 
 *       Prototypes for Completer-Initiator (CI) Functions
 * -----------------------------------------------------------------*/

#ifndef XCI_H_INCLUDED                               
#define XCI_H_INCLUDED

#include <xcidefs.h>

#ifndef CLI
#define CLI
#endif

#ifdef __cplusplus
extern "C" {
#endif

/********************************************************************
  CI programming ****************************************************
 ********************************************************************/

CLI bx_errtype EXPORT BestXCIProg(            /* @ciprog */
  bx_handletype  handle
);

CLI bx_errtype EXPORT BestXCIRead(            /* @ciread */
  bx_handletype  handle,
  bx_int32 option
);


/********************************************************************
  CI generics *******************************************************
 *******************************************************************/

CLI bx_errtype EXPORT BestXCIGenDefaultSet(  /* @cigendefset */
  bx_handletype  handle
);

CLI bx_errtype EXPORT BestXCIGenGet(         /* @cigenget */
  bx_handletype  handle,
  bx_cigentype    prop,                              
  bx_int32       *val                        /* #RETURN "0x%08lx" */
);

CLI bx_errtype EXPORT BestXCIGenSet(         /* @cigenset */
  bx_handletype  handle,
  bx_cigentype prop,                                 
  bx_int32    val                                
);

CLI bx_errtype EXPORT BestXCIGenProg(        /* @cigenprog */
  bx_handletype        handle
);

CLI bx_errtype EXPORT BestXCIGenRead(        /* @cigenread */
  bx_handletype        handle
);

/********************************************************************
  CI behavior *******************************************************
 *******************************************************************/

CLI  bx_errtype EXPORT BestXCIBehMemInit(     /* @cibehmeminit */
  bx_handletype handle
);

CLI  bx_errtype EXPORT BestXCIBehDefaultSet(  /* @cibehdefset */
  bx_handletype handle,
  bx_int32 offset
);

CLI bx_errtype EXPORT BestXCIBehSet(          /* @cibehset */
  bx_handletype handle,
  bx_int32 offset,
  bx_cibehtype prop,                                   
  bx_int32 val                                       
);

CLI  bx_errtype EXPORT BestXCIBehGet(         /* @cibehget */      
  bx_handletype handle,
  bx_int32 offset,
  bx_cibehtype prop,                                     
  bx_int32   *val                             /* #RETURN "0x%08lx" */
);

CLI bx_errtype EXPORT BestXCIBehProg(         /* @cibehprog */
  bx_handletype  handle
);

CLI bx_errtype EXPORT BestXCIBehRead(         /* @cibehread */
  bx_handletype  handle,
  bx_int32 option
);

CLI bx_errtype EXPORT BestXCIBehCopyLine(     /* @cibehcopyline */
  bx_handletype  handle,
  bx_int32 srcline,
  bx_int32 destline
);


#ifdef __cplusplus
}
#endif

#endif
